/*
 * Decompiled with CFR 0.152.
 */
package conflicts;

import conflicts.Cluster;
import conflicts.Mapping;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;

public class Splitting {
    public static void main(String[] args) {
        int minLen = Integer.parseInt(args[1]);
        int maxLen = Integer.parseInt(args[2]);
        int[] qs = new int[]{5, 8, 12, 15, 18, 21, 24, 25, 27, 28, 29, 30, 31, 32, 33, 34, 36, 38, 41, 44, 47, 50};
        int j = 0;
        while (j < qs.length) {
            int qual = qs[j];
            int good = 0;
            int bad = 0;
            File file = new File(args[0]);
            File fileMappings = new File(args[3]);
            try {
                int pos = 0;
                String line = null;
                BufferedReader br = new BufferedReader(new FileReader(file));
                BufferedReader brMappings = new BufferedReader(new FileReader(fileMappings));
                int genomeLength = 0;
                while ((line = brMappings.readLine()) != null) {
                    String[] cols = line.split("\t");
                    Integer loc = Integer.parseInt(cols[2]);
                    Double q = Double.parseDouble(cols[8]);
                    int readlen = Integer.parseInt(cols[13]);
                    if (!(q > 0.0) || loc + readlen <= genomeLength) continue;
                    genomeLength = loc + readlen;
                }
                boolean[] genomeCoverage = new boolean[genomeLength];
                int i = 0;
                while (i < genomeCoverage.length) {
                    genomeCoverage[i] = false;
                    ++i;
                }
                brMappings = new BufferedReader(new FileReader(fileMappings));
                while ((line = brMappings.readLine()) != null) {
                    String[] cols = line.split("\t");
                    Integer loc = Integer.parseInt(cols[2]);
                    Double q = Double.parseDouble(cols[8]);
                    int readlen = Integer.parseInt(cols[13]);
                    if (!(q >= (double)qual)) continue;
                    int i2 = 0;
                    while (i2 < readlen) {
                        genomeCoverage[loc.intValue() + i2] = true;
                        ++i2;
                    }
                }
                br = new BufferedReader(new FileReader(file));
                while ((line = br.readLine()) != null) {
                    Cluster cluster = new Cluster(line, ++pos, maxLen, minLen, qual);
                    if (cluster.trapezoid.ranMin == -1) continue;
                    int free = 0;
                    int breaks = 0;
                    int run = 0;
                    Vector<Integer> runs = new Vector<Integer>();
                    int i3 = cluster.trapezoid.l + 1;
                    while (i3 < cluster.trapezoid.r) {
                        if (!genomeCoverage[i3]) {
                            ++free;
                            ++run;
                        }
                        if (genomeCoverage[i3] && !genomeCoverage[i3 - 1]) {
                            ++breaks;
                            runs.add(run);
                            run = 0;
                        }
                        ++i3;
                    }
                    if (free >= cluster.trapezoid.ranMin) {
                        ++good;
                    } else {
                        ++bad;
                    }
                    int l = 0;
                    int r = 0;
                    for (Mapping m1 : cluster.mappings) {
                        for (Mapping m2 : cluster.mappings) {
                            l = Math.max(l, Math.abs((Integer)m1.fst - (Integer)m2.fst));
                            r = Math.max(r, Math.abs((Integer)m1.snd - (Integer)m2.snd));
                        }
                    }
                }
                System.out.println(String.valueOf(qual) + " " + 1.0 * (double)good / (double)(good + bad));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            ++j;
        }
    }
}

