/*
 * Decompiled with CFR 0.152.
 */
package conflicts;

import conflicts.Edge;
import conflicts.FloydWarshall;
import conflicts.Interval;
import conflicts.ListTree;
import conflicts.Mapping;
import conflicts.Node;
import conflicts.SortedList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplittingNew {
    public static void main(String[] args) {
        String file = args.length > 0 ? args[0] : "/prj/cancersv/bcca/allChromosomes/HS0771_12_lanes.out.chr21.flag18.minqual20.head";
        int minLen = args.length > 1 ? Integer.parseInt(args[1]) : 126;
        int maxLen = args.length > 2 ? Integer.parseInt(args[2]) : 263;
        int maxDepth = args.length > 3 ? Integer.parseInt(args[3]) : -1;
        int windowSize = args.length > 4 ? Integer.parseInt(args[4]) : 1000;
        Vector<Mapping> ms = SplittingNew.readMappings(file, minLen, maxLen);
        System.out.println(String.valueOf(ms.size()) + " mappings with quality>=20 read");
        SplittingNew.computeCIwindowWise(ms, minLen, maxLen, maxDepth, windowSize);
    }

    private static Vector<Mapping> readMappings(String filename, int minLen, int maxLen) {
        HashMap<String, Integer> reads = new HashMap<String, Integer>();
        Vector<Mapping> ms = new Vector<Mapping>();
        try {
            String line1;
            File file = new File(filename);
            BufferedReader br1 = new BufferedReader(new FileReader(file));
            while ((line1 = br1.readLine()) != null) {
                Mapping mapping = null;
                String[] cols = line1.split("\t");
                Integer pos = Integer.parseInt(cols[2]);
                String id = cols[0].substring(0, cols[0].indexOf(47));
                Double q = Double.parseDouble(cols[8]);
                if (!(q >= 20.0)) continue;
                if (reads.containsKey(id)) {
                    int p1 = (Integer)reads.get(id);
                    int p2 = Integer.parseInt(cols[2]);
                    int readlen = Integer.parseInt(cols[13]);
                    mapping = p1 < p2 ? new Mapping(p1 + readlen, p2 - 1, id, q, readlen) : new Mapping(p2 + readlen, p1 - 1, id, q, readlen);
                    if ((Integer)mapping.snd - (Integer)mapping.fst + 1 >= 0) {
                        ms.add(mapping);
                    }
                    reads.remove(id);
                    continue;
                }
                reads.put(id, pos);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return ms;
    }

    public static void computeCI(Vector<Mapping> ms, int minLen, int maxLen, int maxDepth) {
        ListTree<Mapping> conflSubs = new ListTree<Mapping>(new Mapping(0, 0, ""));
        HashMap<String, Integer> ci = new HashMap<String, Integer>();
        SplittingNew.getMinimalConflictingSets(ms, conflSubs, ci, minLen, maxLen, maxDepth, new Random(1L));
        System.out.println("minimal conflicting sets: " + conflSubs.size());
        for (Mapping i : ms) {
            Integer c = ci.get(i.id);
            if (c == null) continue;
            System.out.println(String.valueOf(i.id) + "\t" + c);
        }
    }

    public static void computeCIwindowWise(Vector<Mapping> ms, int minLen, int maxLen, int maxDepth, int windowSize) {
        Random random = new Random(1L);
        ListTree<Mapping> conflSubs = new ListTree<Mapping>(new Mapping(0, 0, ""));
        HashMap<String, Integer> ci = new HashMap<String, Integer>();
        Integer min = Integer.MAX_VALUE;
        Integer max = 0;
        for (Mapping m : ms) {
            min = Math.min(min, (Integer)m.fst);
            max = Math.max(max, (Integer)m.snd);
        }
        System.out.println("first position: " + min);
        System.out.println("last position: " + max);
        int oldConflsubSize = 0;
        int i = min;
        while (i + windowSize / 2 <= max) {
            Vector<Mapping> mWindow = new Vector<Mapping>();
            for (Mapping m : ms) {
                if ((Integer)m.fst < i || (Integer)m.snd > i + windowSize) continue;
                mWindow.add(m);
            }
            SplittingNew.getMinimalConflictingSets(mWindow, conflSubs, ci, minLen, maxLen, maxDepth, random);
            oldConflsubSize = conflSubs.size();
            i += windowSize / 2;
        }
        System.out.println("---");
        System.out.println("minimal conflicting sets in total: " + conflSubs.size());
        for (Mapping i2 : ms) {
            Integer c = ci.get(i2.id);
            if (c == null) continue;
            System.out.println(String.valueOf(i2.id) + "\t" + c);
        }
    }

    private static Vector<Interval> getIntervalsFromMappings(List<Mapping> ms, int minLen, int maxLen) {
        Vector<Interval> intervals = new Vector<Interval>();
        if (ms.isEmpty()) {
            System.out.println("*** getIntervalsFromMappings EMPTY LIST!");
            return intervals;
        }
        Integer min = Integer.MAX_VALUE;
        Integer max = 0;
        for (Mapping m : ms) {
            min = Math.min(min, (Integer)m.fst - m.readLen);
            max = Math.max(max, (Integer)m.snd + m.readLen);
        }
        int[] u = new int[max - min + 1];
        for (Mapping m : ms) {
            int i = 1;
            while (i <= m.readLen) {
                u[((Integer)m.fst).intValue() - i - min.intValue()] = 1;
                u[((Integer)m.snd).intValue() + i - min.intValue()] = 1;
                ++i;
            }
        }
        int[] left = new int[max - min + 1];
        int[] right = new int[max - min + 1];
        int sum = 0;
        int leftfree = -1;
        int rightfree = -1;
        int i = 0;
        while (i < u.length) {
            if (u[i] == 0) {
                leftfree = i;
            }
            left[i] = leftfree;
            if (u[u.length - 1 - i] == 0) {
                rightfree = u.length - 1 - i;
            }
            right[u.length - 1 - i] = rightfree;
            ++i;
        }
        i = 0;
        while (i < u.length) {
            if (u[i] != 0) {
                // empty if block
            }
            u[i] = ++sum;
            ++i;
        }
        for (Mapping m : ms) {
            int l = right[(Integer)m.fst - min];
            int r = left[(Integer)m.snd - min];
            if (l == -1 || r == -1) {
                return null;
            }
            int minVal = minLen - 2 * m.readLen - (u[(Integer)m.snd - min] - u[(Integer)m.fst - min - 1]);
            int maxVal = maxLen - 2 * m.readLen - (u[(Integer)m.snd - min] - u[(Integer)m.fst - min - 1]);
            minVal = Math.max(minVal, 0);
            if (maxVal < 0) {
                return null;
            }
            l -= u[l];
            r -= u[r];
            Interval i2 = new Interval(m.id, l, r, minVal, maxVal);
            intervals.add(i2);
        }
        return intervals;
    }

    private static boolean isValidGraph(List<Mapping> ms, int minLen, int maxLen) {
        Vector<Interval> intervals = SplittingNew.getIntervalsFromMappings(ms, minLen, maxLen);
        if (intervals == null) {
            return false;
        }
        return SplittingNew.isValidGraph(intervals);
    }

    public static void getMinimalConflictingSets(Vector<Mapping> ms, ListTree<Mapping> conflSubs, HashMap<String, Integer> ci, int minLen, int maxLen, int maxDepth, Random random) {
        Collections.shuffle(ms, random);
        Vector<Mapping> m1 = new Vector<Mapping>();
        boolean conf = false;
        for (Mapping m : ms) {
            m1.add(m);
            boolean bl = conf = !SplittingNew.isValidGraph(m1, minLen, maxLen);
            if (conf) break;
        }
        if (!conf) {
            return;
        }
        if (m1.size() == 1) {
            System.out.println("*** minimal conflicing set of size ONE?!");
            System.out.println(((Mapping)m1.firstElement()).toString());
            System.out.println(String.valueOf(minLen) + "," + maxLen);
        }
        Vector<Mapping> m2 = new Vector<Mapping>();
        m2.addAll(m1);
        for (Mapping i_skip : m1) {
            int pos = m2.indexOf(i_skip);
            m2.remove(i_skip);
            if (!SplittingNew.isValidGraph(m2, minLen, maxLen)) continue;
            m2.add(pos, i_skip);
        }
        SortedList<Mapping> m2sorted = new SortedList<Mapping>();
        m2sorted.addAll((List<Mapping>)m2);
        if (conflSubs.haveToAdd(m2sorted)) {
            for (Mapping i : m2) {
                Integer oldCi = ci.remove(i.id);
                if (oldCi == null) {
                    oldCi = 0;
                }
                ci.put(i.id, oldCi + 1);
            }
        }
        if (maxDepth != 0) {
            for (Mapping i_skip : m2) {
                Vector<Mapping> m3 = new Vector<Mapping>();
                for (Mapping i : m1) {
                    if (i == i_skip) continue;
                    m3.add(i);
                }
                SplittingNew.getMinimalConflictingSets(m3, conflSubs, ci, minLen, maxLen, maxDepth - 1, random);
            }
        }
    }

    private static void resetCIs(Vector<Interval> m) {
        for (Interval i : m) {
            i.resetCI();
        }
    }

    public static String printSetI(Vector<Interval> setI) {
        String s = "";
        for (Interval interval : setI) {
            s = String.valueOf(s) + "i=new Interval(" + interval.toString() + ");\tsetI.add(i);\n";
        }
        return s;
    }

    public static int getRand(int min, int max) {
        return min + (int)(Math.random() * (double)(max - min + 1));
    }

    public static void testRand(int n, int maxRuns, int maxSize) {
        int runs = 0;
        block0: while (maxRuns < 0 || runs <= maxRuns) {
            Vector<Interval> setI = new Vector<Interval>();
            if (++runs % 1000 == 0) {
                System.out.print(".");
            }
            while (setI.size() <= maxSize) {
                int l = SplittingNew.getRand(0, n - 1);
                int r = SplittingNew.getRand(l + 1, n);
                int min = SplittingNew.getRand(1, r - l + 1);
                int max = SplittingNew.getRand(min, r - l + 1);
                Interval i = new Interval(l, r, min, max);
                if (r - l + 1 <= min) continue;
                i = new Interval(l, r, min, max);
                setI.add(i);
                boolean validN = SplittingNew.isValidNaiv(setI, n);
                boolean valid = SplittingNew.isValidGraph((Vector)setI.clone());
                if (validN != valid) {
                    System.out.println("counterexample:");
                    System.out.println(SplittingNew.printSetI(setI));
                    System.exit(0);
                }
                if (validN && valid) continue;
                continue block0;
            }
        }
    }

    public static boolean isValidGraph(Vector<Interval> setI) {
        SortedList<Integer> partitionBoundaries = new SortedList<Integer>();
        for (Interval i : setI) {
            if (!partitionBoundaries.contains(i.l - 1)) {
                partitionBoundaries.add(i.l - 1);
            }
            if (partitionBoundaries.contains(i.r)) continue;
            partitionBoundaries.add(i.r);
        }
        Node[] nodes = new Node[partitionBoundaries.size()];
        HashMap<Integer, Node> intPartMap = new HashMap<Integer, Node>();
        int i = 0;
        while (i < partitionBoundaries.size()) {
            Integer b = (Integer)partitionBoundaries.get(i);
            nodes[i] = new Node(b, i);
            intPartMap.put(b, nodes[i]);
            ++i;
        }
        Edge[] edges = new Edge[nodes.length - 1 + 2 * setI.size()];
        Node prev = nodes[0];
        int n = 1;
        while (n < nodes.length) {
            Node next = nodes[n];
            edges[n - 1] = new Edge(prev, next, 0);
            prev = next;
            ++n;
        }
        int i2 = 0;
        while (i2 < setI.size()) {
            Node from = (Node)intPartMap.get(setI.get((int)i2).l - 1);
            Node to = (Node)intPartMap.get(setI.get((int)i2).r);
            edges[1 * nodes.length - 1 + i2] = new Edge(from, to, -setI.get((int)i2).min);
            edges[1 * nodes.length - 1 + setI.size() + i2] = new Edge(to, from, setI.get((int)i2).max);
            ++i2;
        }
        FloydWarshall graph = new FloydWarshall(nodes, edges);
        boolean feasible = true;
        int i3 = 0;
        while (i3 < nodes.length && feasible) {
            if (graph.getShortestDistance(nodes[i3], nodes[i3]) < 0) {
                feasible = false;
            }
            ++i3;
        }
        return feasible;
    }

    public static boolean isValidD(Vector<Interval> setI, String d, int n) {
        for (Interval interval : setI) {
            int count = 0;
            int i = interval.l;
            while (i <= interval.r) {
                if (d.charAt(i) == '1') {
                    ++count;
                }
                ++i;
            }
            if (count < interval.min) {
                return false;
            }
            if (count <= interval.max) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidNaiv(Vector<Interval> setI, int n) {
        long max = (long)Math.pow(2.0, n + 1) - 1L;
        Long i = new Long(1L);
        while (i <= max) {
            String d = Long.toBinaryString(i);
            while (d.length() <= n) {
                d = "0" + d;
            }
            if (SplittingNew.isValidD(setI, d, n)) {
                return true;
            }
            i = i + 1L;
        }
        return false;
    }
}

