/*
 * Decompiled with CFR 0.152.
 */
package conflicts;

import conflicts.Edge;
import conflicts.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FloydWarshall {
    private final int[][] D;
    private final Node[][] P;

    public FloydWarshall(Node[] nodes, Edge[] edges) {
        int maxNodes = 23000;
        assert (nodes.length < 23000) : "nodes.length cannot exceed 23000.\nSize of class data structures is at least (2*(node size)*nodes.length**2).";
        this.D = this.initializeWeight(nodes, edges);
        this.P = new Node[nodes.length][nodes.length];
        int k = 0;
        while (k < nodes.length) {
            int i = 0;
            while (i < nodes.length) {
                int j = 0;
                while (j < nodes.length) {
                    if (this.D[i][k] != Integer.MAX_VALUE && this.D[k][j] != Integer.MAX_VALUE && this.D[i][k] + this.D[k][j] < this.D[i][j]) {
                        this.D[i][j] = this.D[i][k] + this.D[k][j];
                        this.P[i][j] = nodes[k];
                    }
                    ++j;
                }
                ++i;
            }
            ++k;
        }
    }

    public int getShortestDistance(Node source, Node target) {
        return this.D[source.index][target.index];
    }

    public List<Node> getShortestPath(Node source, Node target) {
        if (this.D[source.index][target.index] == Integer.MAX_VALUE) {
            return new ArrayList<Node>();
        }
        List<Node> path = this.getIntermediatePath(source, target);
        path.add(0, source);
        path.add(target);
        return path;
    }

    private List<Node> getIntermediatePath(Node source, Node target) {
        if (this.P[source.index][target.index] == null) {
            return new ArrayList<Node>();
        }
        ArrayList<Node> path = new ArrayList<Node>();
        path.addAll(this.getIntermediatePath(source, this.P[source.index][target.index]));
        path.add(this.P[source.index][target.index]);
        path.addAll(this.getIntermediatePath(this.P[source.index][target.index], target));
        return path;
    }

    private int[][] initializeWeight(Node[] nodes, Edge[] edges) {
        int[][] Weight = new int[nodes.length][nodes.length];
        int i = 0;
        while (i < nodes.length) {
            Arrays.fill(Weight[i], Integer.MAX_VALUE);
            ++i;
        }
        Edge[] edgeArray = edges;
        int n = edges.length;
        int n2 = 0;
        while (n2 < n) {
            Edge e = edgeArray[n2];
            Weight[e.from.index][e.to.index] = Math.min(Weight[e.from.index][e.to.index], e.weight);
            ++n2;
        }
        return Weight;
    }
}

