/*
 * Decompiled with CFR 0.152.
 */
package conflicts;

import conflicts.Cluster;
import conflicts.Mapping;
import conflicts.Mappings;
import conflicts.Pair;
import conflicts.SplitMixed;
import conflicts.Trapezoid;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchConflicts {
    public static void main(String[] args) {
        int minLen = Integer.parseInt(args[1]);
        int maxLen = Integer.parseInt(args[2]);
        int minClusterSize = Integer.parseInt(args[3]);
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            System.out.println(s);
            ++n2;
        }
        HashMap<Integer, Pair<Integer, Integer>> confClusterCoordinates = new HashMap<Integer, Pair<Integer, Integer>>();
        Object concordants = null;
        boolean lc = false;
        int l = 0;
        Object line2 = null;
        double[][] minScoreMatrixCon = null;
        int[][] mcsNumberMatrixCon = null;
        int[][] maxCIMatrixCon = null;
        boolean concGenomeLength = false;
        int[][] concCoverage = null;
        Vector<Cluster> clusters = new Vector<Cluster>();
        try {
            String line1;
            File file = new File(args[0]);
            BufferedReader br1 = new BufferedReader(new FileReader(file));
            Object br2 = null;
            int pos1 = 0;
            while ((line1 = br1.readLine()) != null) {
                Cluster cluster2 = new Cluster(line1, pos1, maxLen, minLen);
                if (cluster2.size() < minClusterSize) continue;
                ++pos1;
                if (cluster2.trapezoid.r - cluster2.trapezoid.l - cluster2.trapezoid.ranMin - 1 < 1) {
                    System.out.println(">" + pos1);
                    System.out.println(">" + line1);
                    System.out.println(">" + cluster2.trapezoid.r + " " + cluster2.trapezoid.l + " " + cluster2.trapezoid.ranMin);
                    System.exit(1);
                }
                clusters.add(cluster2);
            }
            br1.close();
            System.out.println("Clusters read.");
            l = clusters.size();
            double[][] minScoreMatrix = new double[l][l];
            int[] lengths = new int[l];
            int[] mappings = new int[l];
            pos1 = 0;
            for (Cluster cluster1 : clusters) {
                if (pos1 * 100 % clusters.size() == 0) {
                    System.out.print("\nchecking cluster " + cluster1.id + " of " + clusters.size());
                }
                lengths[pos1] = cluster1.trapezoid.ranMin;
                mappings[pos1] = cluster1.mappings.size();
                int pos2 = 0;
                for (Cluster cluster2 : clusters) {
                    if (pos2 > pos1) {
                        int conflCount = 0;
                        conflCount = SearchConflicts.findConfl(pos1, cluster1, pos2, cluster2, minScoreMatrix);
                        if (conflCount > 0) {
                            confClusterCoordinates.put(pos2, new Pair<Integer, Integer>(cluster2.trapezoid.l, cluster2.trapezoid.r));
                        }
                        if ((conflCount = SearchConflicts.findConfl(pos2, cluster2, pos1, cluster1, minScoreMatrix)) > 0) {
                            confClusterCoordinates.put(pos1, new Pair<Integer, Integer>(cluster1.trapezoid.l, cluster1.trapezoid.r));
                        }
                    }
                    ++pos2;
                }
                ++pos1;
            }
            System.out.println("\nConflicts determined.");
            Vector<Integer> confClust = new Vector<Integer>();
            System.out.println("*** cliques of three");
            int c = 0;
            int i = 0;
            while (i < l) {
                int n3 = 0;
                int j = i + 1;
                while (j < l) {
                    int k = j + 1;
                    while (k < l) {
                        if (!(minScoreMatrix[i][j] == 0.0 && minScoreMatrix[j][i] == 0.0 || minScoreMatrix[i][k] == 0.0 && minScoreMatrix[k][i] == 0.0 || minScoreMatrix[j][k] == 0.0 && minScoreMatrix[k][j] == 0.0)) {
                            System.out.println("clique: " + i + " " + j + " " + k);
                            ++n3;
                            ++c;
                            if (!confClust.contains(i)) {
                                confClust.add(i);
                            }
                            if (!confClust.contains(j)) {
                                confClust.add(j);
                            }
                            if (!confClust.contains(k)) {
                                confClust.add(k);
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            System.out.println("\n*** confl. cliques: " + c);
            System.out.println("*** conflicting clusters (cluster length size): " + confClust.size());
            Vector<Mapping> confMappings = new Vector<Mapping>();
            for (Integer i2 : confClust) {
                System.out.println("@1 " + i2 + " " + lengths[i2] + " " + mappings[i2]);
                for (Mapping m : ((Cluster)clusters.get((int)i2.intValue())).mappings) {
                    if (confMappings.contains(m)) continue;
                    confMappings.add(m);
                }
            }
            System.out.println("*** conflicting mappings: " + confMappings.size());
            if (args.length > 4) {
                System.out.println("*** conflicting cliques of conc + disc1 + disc2 (disc1.length disc1.size disc2.length disc2.size)...");
                HashMap<String, Integer> reads = new HashMap<String, Integer>();
                Vector<Mapping> confConc = new Vector<Mapping>();
                Vector<Integer> confClustConc = new Vector<Integer>();
                pos1 = 0;
                file = new File(args[4]);
                br1 = new BufferedReader(new FileReader(file));
                c = 0;
                System.out.println("checking concordant data:");
                while ((line1 = br1.readLine()) != null) {
                    Mapping mapping = null;
                    String[] cols = line1.split("\t");
                    Integer pos = Integer.parseInt(cols[2]);
                    String id = cols[0].substring(0, cols[0].indexOf(47));
                    if (reads.containsKey(id)) {
                        Double q = Double.parseDouble(cols[8]);
                        int p1 = (Integer)reads.get(id);
                        int p2 = Integer.parseInt(cols[2]);
                        int readlen = Integer.parseInt(cols[13]);
                        if (Math.abs(p2 - p1) + readlen <= maxLen && q > 0.0) {
                            mapping = p1 < p2 ? new Mapping(p1 + readlen, p2, id, q, readlen) : new Mapping(p2 + readlen, p1, id, q, readlen);
                            int j = 0;
                            while (j < l) {
                                Cluster cj = (Cluster)clusters.get(j);
                                if (cj.trapezoid.rr > (Integer)mapping.fst - mapping.readLen && cj.trapezoid.ll < (Integer)mapping.snd + mapping.readLen) {
                                    int k = j + 1;
                                    while (k < l) {
                                        Cluster ck = (Cluster)clusters.get(j);
                                        if (ck.trapezoid.rr > (Integer)mapping.fst - mapping.readLen && ck.trapezoid.ll < (Integer)mapping.snd + mapping.readLen && (minScoreMatrix[j][k] != 0.0 || minScoreMatrix[k][j] != 0.0)) {
                                            boolean confK;
                                            Vector<Mapping> ms = new Vector<Mapping>();
                                            ms.add(mapping);
                                            boolean confJ = !SearchConflicts.checkCompatibility(ms, cj, minLen, 0);
                                            boolean bl = confK = !SearchConflicts.checkCompatibility(ms, ck, minLen, 0);
                                            if (confJ && confK) {
                                                ++c;
                                                if (!confConc.contains(mapping)) {
                                                    confConc.add(mapping);
                                                }
                                                if (!confClustConc.contains(j)) {
                                                    confClustConc.add(j);
                                                }
                                                if (!confClustConc.contains(k)) {
                                                    confClustConc.add(k);
                                                }
                                            }
                                        }
                                        ++k;
                                    }
                                }
                                ++j;
                            }
                        }
                        reads.remove(id);
                        continue;
                    }
                    reads.put(id, pos);
                }
                System.out.println("\n*** conflicting cliques of conc + disc + disc: " + c);
                System.out.println("*** conflicting concordant mappings: " + confConc.size());
                System.out.println("*** conflicting clusters wrt. concordant mappings (cluster length size): " + confClustConc.size());
                for (Integer i3 : confClustConc) {
                    System.out.println("@2 " + i3 + " " + lengths[i3] + " " + mappings[i3]);
                    if (confClust.contains(i3)) continue;
                    confClust.add(i3);
                }
                System.out.println("*** conflicting clusters in total: " + confClust.size());
                Vector<Mapping> confMappingsConc = new Vector<Mapping>();
                for (Integer i4 : confClustConc) {
                    System.out.println("@3 " + i4 + " " + lengths[i4] + " " + mappings[i4]);
                    for (Mapping m : ((Cluster)clusters.get((int)i4.intValue())).mappings) {
                        if (!confMappingsConc.contains(m)) {
                            confMappingsConc.add(m);
                        }
                        if (confMappings.contains(m)) continue;
                        confMappings.add(m);
                    }
                }
                System.out.println("*** conflicting disc. mappings in these clusters: " + confMappingsConc.size());
                System.out.println("*** conflicting disc. mappings in total: " + confMappings.size());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static int findConfl(int pos1, Cluster cluster1, int pos2, Cluster cluster2, double[][] minScoreMatrix, int[][] mcsNumberMatrix, int[][] maxCIMatrix, HashMap<String, Integer> allCIs) {
        Vector<Mappings> conflSubs = new Vector<Mappings>();
        HashMap<String, Integer> ci = new HashMap<String, Integer>();
        SplitMixed.countCi(cluster2.mappings, cluster1, -1, -1, ci, conflSubs, -1, "bs");
        Double maxScore = 0.0;
        int minCI = Integer.MAX_VALUE;
        for (Mappings ms : conflSubs) {
            Double min = Double.MAX_VALUE;
            int maxCI = 0;
            for (Mapping m : ms) {
                if (m.quality < min) {
                    min = m.quality;
                }
                if (ci.get(m.id) > maxCI) {
                    maxCI = ci.get(m.id);
                }
                int oldCI = 0;
                if (allCIs.containsKey(m.id)) {
                    oldCI = allCIs.remove(m.id);
                }
                allCIs.put(m.id, oldCI + ci.get(m.id));
            }
            if (min > maxScore) {
                maxScore = min;
            }
            if (maxCI >= minCI) continue;
            minCI = maxCI;
        }
        minScoreMatrix[pos2][pos1] = conflSubs.size() > 0 ? maxScore : 0.0;
        maxCIMatrix[pos2][pos1] = conflSubs.size() > 0 ? minCI : Integer.MAX_VALUE;
        mcsNumberMatrix[pos2][pos1] = conflSubs.size();
        return conflSubs.size();
    }

    private static int findConfl(int pos1, Cluster cluster1, int pos2, Cluster cluster2, double[][] minScoreMatrix) {
        Vector<Mappings> conflSubs = new Vector<Mappings>();
        HashMap<String, Integer> ci = new HashMap<String, Integer>();
        SearchConflicts.countCi(cluster2.mappings, cluster1, -1, -1, ci, conflSubs, 0, "bs");
        Double maxScore = 0.0;
        int minCI = Integer.MAX_VALUE;
        for (Mappings ms : conflSubs) {
            Double min = Double.MAX_VALUE;
            int maxCI = 0;
            for (Mapping m : ms) {
                if (m.quality < min) {
                    min = m.quality;
                }
                if (ci.get(m.id) > maxCI) {
                    maxCI = ci.get(m.id);
                }
                boolean bl = false;
            }
            if (min > maxScore) {
                maxScore = min;
            }
            if (maxCI >= minCI) continue;
            minCI = maxCI;
        }
        minScoreMatrix[pos2][pos1] = conflSubs.size() > 0 ? maxScore : 0.0;
        return conflSubs.size();
    }

    public static void countCi(Vector<Mapping> ms, Cluster c, int minLenMix, int maxLenMix, Map<String, Integer> ci, Vector<Mappings> conflSubs, int maxDepth, String s) {
        Vector<Mapping> ms2 = new Vector<Mapping>();
        boolean conf = false;
        for (Mapping m : ms) {
            ms2.add(m);
            boolean bl = conf = !SearchConflicts.checkCompatibility(ms2, c, minLenMix, maxLenMix);
            if (conf) break;
        }
        if (!conf) {
            return;
        }
        Mappings ms3 = new Mappings();
        ms3.addAll(ms2);
        for (Mapping m_skip : ms2) {
            int pos = ms3.indexOf(m_skip);
            ms3.remove(m_skip);
            if (!SearchConflicts.checkCompatibility(ms3, c, minLenMix, maxLenMix)) continue;
            ms3.add(pos, m_skip);
        }
        if (!conflSubs.contains(ms3)) {
            conflSubs.add(ms3);
            for (Mapping m : ms3) {
                Integer oldCi = ci.remove(m.id);
                if (oldCi == null) {
                    oldCi = 0;
                }
                ci.put(m.id, oldCi + 1);
            }
        }
    }

    public static boolean checkCompatibility(Vector<Mapping> ms, Cluster c, int minLenMix, int maxLenMix) {
        int i;
        int ll = c.trapezoid.ll;
        int rr = c.trapezoid.rr;
        boolean[] covM = new boolean[rr - ll];
        Arrays.fill(covM, false);
        for (Mapping mms : ms) {
            i = (Integer)mms.fst - mms.readLen + 1;
            while (i < (Integer)mms.snd + mms.readLen) {
                int p = i - ll;
                if (p >= 0 && p < covM.length) {
                    covM[p] = true;
                }
                ++i;
            }
        }
        int cMaxRun = 0;
        int currRun = 0;
        i = c.trapezoid.l - ll + 1;
        while (i < c.trapezoid.r - ll) {
            if (covM[i]) {
                cMaxRun = Math.max(cMaxRun, currRun);
                currRun = 0;
            } else {
                ++currRun;
            }
            ++i;
        }
        return (cMaxRun = Math.max(cMaxRun, currRun)) >= c.trapezoid.ranMin;
    }

    public static boolean Xconflict(Trapezoid t, Mappings ms) {
        int maxNumberPos;
        int numberPos = maxNumberPos = t.r - t.l - t.ranMin + 1;
        boolean[] a = new boolean[maxNumberPos];
        int i = 0;
        while (i < maxNumberPos) {
            a[i] = true;
            ++i;
        }
        for (Mapping m : ms) {
            int from = Math.max((Integer)m.fst - m.readLen + 1 - t.l - t.ranMin, 0);
            int to = Math.min((Integer)m.fst - t.l, maxNumberPos - 1);
            int i2 = from;
            while (i2 <= to) {
                if (a[i2]) {
                    a[i2] = false;
                    if (--numberPos <= 0) {
                        return true;
                    }
                }
                ++i2;
            }
            from = Math.max((Integer)m.snd - t.l - t.ranMin, 0);
            to = Math.min((Integer)m.snd + m.readLen - 1 - t.l, maxNumberPos - 1);
            i2 = from;
            while (i2 <= to) {
                if (a[i2]) {
                    a[i2] = false;
                    if (--numberPos <= 0) {
                        return true;
                    }
                }
                ++i2;
            }
        }
        return false;
    }

    public static void countCi(Trapezoid t, Mappings ms, Map<String, Integer> ci, Vector<Mappings> conflSubs) {
        if (t.r - t.l - 1 < t.ranMin) {
            System.out.println(String.valueOf(t.r) + " " + t.l + " " + t.ranMin);
        }
        int maxNumberPos = t.r - t.l - 1 - t.ranMin + 1;
        Vector<Mapping> ms2 = new Vector<Mapping>();
        boolean[] a = new boolean[maxNumberPos];
        int i = 0;
        while (i < maxNumberPos) {
            a[i] = true;
            ++i;
        }
        int numberPos = maxNumberPos;
        for (Mapping m : ms) {
            ms2.add(m);
            numberPos = SearchConflicts.filter(a, numberPos, m, t);
            if (numberPos <= 0) break;
        }
        if (numberPos > 0) {
            return;
        }
        Mappings ms3 = new Mappings();
        for (Mapping m : ms2) {
            ms3.add(m);
        }
        for (Mapping m_skip : ms2) {
            a = new boolean[maxNumberPos];
            int i2 = 0;
            while (i2 < maxNumberPos) {
                a[i2] = true;
                ++i2;
            }
            numberPos = maxNumberPos;
            for (Mapping m : ms3) {
                if (m != m_skip) {
                    numberPos = SearchConflicts.filter(a, numberPos, m, t);
                }
                if (numberPos <= 0) break;
            }
            if (numberPos > 0) continue;
            ms3.remove(m_skip);
        }
        if (!conflSubs.contains(ms3)) {
            conflSubs.add(ms3);
            for (Mapping m : ms3) {
                Integer oldCi = ci.remove(m.id);
                if (oldCi == null) {
                    oldCi = 0;
                }
                ci.put(m.id, oldCi + 1);
            }
        }
        for (Mapping m_skip : ms3) {
            Mappings ms4 = new Mappings();
            for (Mapping m : ms) {
                if (m == m_skip) continue;
                ms4.add(m);
            }
            SearchConflicts.countCi(t, ms4, ci, conflSubs);
        }
    }

    private static int filter(boolean[] a, int numberPos, Mapping m, Trapezoid t) {
        int maxNumberPos = a.length;
        int from = Math.max((Integer)m.fst - m.readLen + 1 - t.l - t.ranMin, 0);
        int to = Math.min((Integer)m.fst - t.l, maxNumberPos - 1);
        int i = from;
        while (i <= to) {
            if (a[i]) {
                a[i] = false;
                if (--numberPos <= 0) {
                    return numberPos;
                }
            }
            ++i;
        }
        from = Math.max((Integer)m.snd - t.l - t.ranMin, 0);
        to = Math.min((Integer)m.snd + m.readLen - 1 - t.l, maxNumberPos - 1);
        i = from;
        while (i <= to) {
            if (a[i]) {
                a[i] = false;
                if (--numberPos <= 0) {
                    return numberPos;
                }
            }
            ++i;
        }
        return numberPos;
    }

    public static boolean weirdCase(Trapezoid t, Mappings ms, int readLen) {
        int maxNumberPos;
        int numberPos = maxNumberPos = t.r - t.l - t.ranMin + 1;
        boolean[] a = new boolean[maxNumberPos];
        int i = 0;
        while (i < maxNumberPos) {
            a[i] = true;
            ++i;
        }
        int l = 0;
        int r = Integer.MAX_VALUE;
        for (Mapping m : ms) {
            int from = Math.max((Integer)m.fst - readLen + 1 - t.l - t.ranMin, 0);
            int to = Math.min((Integer)m.fst - t.l, maxNumberPos - 1);
            int i2 = from;
            while (i2 <= to) {
                if (a[i2]) {
                    a[i2] = false;
                    if (--numberPos <= 0) {
                        return false;
                    }
                }
                ++i2;
            }
            if ((Integer)m.fst - t.l > l) {
                l = (Integer)m.fst - t.l;
            }
            from = Math.max((Integer)m.snd - t.l - t.ranMin, 0);
            to = Math.min((Integer)m.snd + readLen - 1 - t.l, maxNumberPos - 1);
            i2 = from;
            while (i2 <= to) {
                if (a[i2]) {
                    a[i2] = false;
                    if (--numberPos <= 0) {
                        return false;
                    }
                }
                ++i2;
            }
            if ((Integer)m.snd - t.l >= r) continue;
            r = (Integer)m.snd - t.l;
        }
        int i3 = 0;
        while (i3 < a.length) {
            if (a[i3] && i3 > l && r < r) {
                return false;
            }
            ++i3;
        }
        return true;
    }
}

