/*
 * Decompiled with CFR 0.152.
 */
package conflicts;

import conflicts.Cluster;
import conflicts.Component;
import conflicts.Mapping;
import conflicts.Mappings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitMixed {
    public static void main(String[] args) {
        String clustersFileNormal = args[0];
        int minLenNormal = Integer.parseInt(args[1]);
        int maxLenNormal = Integer.parseInt(args[2]);
        int minClusterSize = Integer.parseInt(args[3]);
        String mappingsFileNormal = args[4];
        int minLenMix = Integer.parseInt(args[5]);
        int maxLenMix = Integer.parseInt(args[6]);
        String mappingsFileMix = args[7];
        String genesFile = args.length > 9 ? args[9] : null;
        String dupsFile = args.length > 10 ? args[10] : null;
        String varsFile = args.length > 11 ? args[11] : null;
        File outClustersFile = null;
        BufferedWriter outClustersBuffer = null;
        File outClustersMappingsFile = null;
        BufferedWriter outClustersMappingsBuffer = null;
        File outMappingsFile = null;
        BufferedWriter outMappingsBuffer = null;
        File outInfoFile = null;
        BufferedWriter outInfoBuffer = null;
        if (args.length > 8) {
            outClustersFile = new File(String.valueOf(args[8]) + ".clusters");
            outClustersMappingsFile = new File(String.valueOf(args[8]) + ".clusters.mappings");
            outMappingsFile = new File(String.valueOf(args[8]) + ".mappings");
            outInfoFile = new File(String.valueOf(args[8]) + ".info");
            try {
                outClustersBuffer = new BufferedWriter(new FileWriter(outClustersFile));
                outClustersMappingsBuffer = new BufferedWriter(new FileWriter(outClustersMappingsFile));
                outClustersBuffer.write("#ID\tTYPE\tHET\tLL\tL\tR\tRR\tRANMIN\tRANMAX\tCSIZE\tMINQUAL\tAVGQUAL\tGENEL\tDISTL\tGENER\tDISTR\tDUPS\tVARS\n");
                outMappingsBuffer = new BufferedWriter(new FileWriter(outMappingsFile));
                outInfoBuffer = new BufferedWriter(new FileWriter(outInfoFile));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            SplitMixed.out(outInfoBuffer, s);
            ++n2;
        }
        int l = 0;
        int genomeLength = 0;
        boolean[] unichrom = null;
        boolean[] overlapping = null;
        Vector<Cluster> normalClusters = new Vector<Cluster>();
        try {
            String line1;
            int i;
            Mappings concordantsNormal = new Mappings();
            Mappings discordantsNormal = new Mappings();
            SplitMixed.out(outInfoBuffer, ">>> reading normal set...");
            genomeLength = SplitMixed.readMappings(mappingsFileNormal, minLenNormal, maxLenNormal, concordantsNormal, discordantsNormal, outInfoBuffer);
            int compressionFactor = 1;
            int arrayLength = (genomeLength += 100) / compressionFactor + 1;
            int[] concCoverage = new int[arrayLength];
            int[] discCoverage = new int[arrayLength];
            int i2 = 0;
            while (i2 < arrayLength) {
                concCoverage[i2] = 0;
                discCoverage[i2] = 0;
                ++i2;
            }
            for (Mapping mapping : concordantsNormal) {
                i = (Integer)mapping.fst - mapping.readLen + 1;
                while (i <= (Integer)mapping.snd + mapping.readLen - 1) {
                    int n3 = i / compressionFactor;
                    concCoverage[n3] = concCoverage[n3] + 1;
                    ++i;
                }
            }
            for (Mapping mapping : discordantsNormal) {
                i = (Integer)mapping.fst;
                while (i <= (Integer)mapping.snd) {
                    int n4 = i / compressionFactor;
                    discCoverage[n4] = discCoverage[n4] + 1;
                    ++i;
                }
            }
            discordantsNormal.removeAllElements();
            double avgCovCon = 0.0;
            i = 1;
            while (i < arrayLength) {
                avgCovCon += (double)concCoverage[i];
                ++i;
            }
            SplitMixed.out(outInfoBuffer, ">>> average coverage by concordant mappings:\n" + (avgCovCon /= (double)arrayLength));
            double avgCovDis = 0.0;
            int i3 = 1;
            while (i3 < arrayLength) {
                avgCovDis += (double)discCoverage[i3];
                ++i3;
            }
            SplitMixed.out(outInfoBuffer, ">>> average coverage by discordant mappings:\n" + (avgCovDis /= (double)arrayLength));
            File file = new File(clustersFileNormal);
            BufferedReader br1 = new BufferedReader(new FileReader(file));
            int pos1 = 0;
            while ((line1 = br1.readLine()) != null) {
                Cluster cluster1 = new Cluster(line1, l, maxLenNormal, minLenNormal);
                if (cluster1.size() >= minClusterSize) {
                    normalClusters.add(cluster1);
                    ++l;
                }
                ++pos1;
            }
            br1.close();
            unichrom = new boolean[l];
            overlapping = new boolean[l];
            int i4 = 0;
            while (i4 < l) {
                overlapping[i4] = false;
                ++i4;
            }
            block14: for (Cluster cluster1 : normalClusters) {
                int cluster1L = cluster1.trapezoid.l;
                int cluster1R = cluster1.trapezoid.r;
                for (Mapping m : concordantsNormal) {
                    if ((Integer)m.snd + m.readLen - 1 < cluster1.trapezoid.r) {
                        cluster1L = Math.max(cluster1L, (Integer)m.snd + m.readLen - 1);
                    }
                    if ((Integer)m.fst - m.readLen + 1 > cluster1.trapezoid.l) {
                        cluster1R = Math.min(cluster1R, (Integer)m.fst - m.readLen + 1);
                    }
                    if ((Integer)m.snd + m.readLen - 1 > cluster1.trapezoid.r && (Integer)m.fst - m.readLen + 1 < cluster1.trapezoid.l) {
                        cluster1L = cluster1R;
                    }
                    if (cluster1L >= cluster1R) break;
                }
                unichrom[cluster1.id] = cluster1R - cluster1L - 1 < cluster1.trapezoid.ranMin;
                for (Cluster cluster2 : normalClusters) {
                    if (cluster1 == cluster2 || cluster1.trapezoid.ll >= cluster2.trapezoid.r && cluster1.trapezoid.l >= cluster2.trapezoid.rr || cluster2.trapezoid.ll >= cluster1.trapezoid.r && cluster2.trapezoid.l >= cluster1.trapezoid.rr) continue;
                    overlapping[cluster1.id] = true;
                    continue block14;
                }
            }
            concordantsNormal.removeAllElements();
            int no = 0;
            int u = 0;
            int uno = 0;
            int h = 0;
            int i5 = 0;
            while (i5 < l) {
                if (unichrom[i5]) {
                    ++u;
                }
                if (!overlapping[i5]) {
                    ++no;
                }
                if (unichrom[i5] && !overlapping[i5]) {
                    ++uno;
                }
                if (!unichrom[i5] && !overlapping[i5]) {
                    ++h;
                }
                ++i5;
            }
            SplitMixed.out(outInfoBuffer, ">>> clusters total: " + normalClusters.size() + "; not overlapping: " + no + ", unichromosomal: " + u + ", both: " + uno + "; bichromosomal/not overlapping: " + h + "; overlapping/bichromosomal: " + (normalClusters.size() - u - h));
            SplitMixed.out(outInfoBuffer, "@1\t" + normalClusters.size() + "\t" + no + "\t" + u + "\t" + uno + "\t" + h + "\t" + (normalClusters.size() - u - h));
            Vector<Cluster> nonOverlClusters = new Vector<Cluster>();
            int i6 = 0;
            while (i6 < l) {
                if (unichrom[i6] && !overlapping[i6]) {
                    ((Cluster)normalClusters.get((int)i6)).isBiChr = false;
                    nonOverlClusters.add((Cluster)normalClusters.get(i6));
                }
                if (!unichrom[i6] && !overlapping[i6]) {
                    ((Cluster)normalClusters.get((int)i6)).isBiChr = false;
                    nonOverlClusters.add((Cluster)normalClusters.get(i6));
                }
                ++i6;
            }
            Mappings concordantsMix = new Mappings();
            Mappings discordantsMix = new Mappings();
            SplitMixed.out(outInfoBuffer, ">>> reading mixed set...");
            genomeLength = Math.max(SplitMixed.readMappings(mappingsFileMix, minLenMix, maxLenMix, null, discordantsMix, outInfoBuffer), genomeLength);
            SplitMixed.out(outInfoBuffer, ">>> done.");
            Vector<Mapping> supNormalTotal = new Vector<Mapping>();
            Vector<Mapping> confBlockNormalTotal = new Vector<Mapping>();
            Vector<Mapping> noConfNormalBlockTotal = new Vector<Mapping>();
            Vector<Mapping> maxExplainBlockTotal = new Vector<Mapping>();
            int concNewNormal = 0;
            int explainedRemaining = 0;
            Vector<Mapping> supNewNormalBlock = new Vector<Mapping>();
            Vector<Component> components = SplitMixed.composeComponents(minLenMix, maxLenMix, normalClusters, nonOverlClusters, discordantsMix, concordantsMix, supNormalTotal, confBlockNormalTotal, noConfNormalBlockTotal, outInfoBuffer);
            normalClusters.removeAllElements();
            Vector<Mapping> conflictingSupNormalBlockTotal = new Vector<Mapping>();
            Vector<Cluster> newClusters = new Vector<Cluster>();
            Vector<Mapping> concordantsTotal = new Vector<Mapping>();
            int consMappings = 0;
            if (outMappingsBuffer != null) {
                for (Component comp : components) {
                    for (Mapping m : comp.getAllMappings()) {
                        Object s = "";
                        s = String.valueOf(s) + m.id + "\t";
                        s = String.valueOf(s) + "21\t" + ((Integer)m.fst - m.readLen) + "\t" + m.fst + "\t+\t";
                        s = String.valueOf(s) + "21\t" + m.snd + "\t" + ((Integer)m.snd - m.readLen) + "\t-\t\n";
                        outMappingsBuffer.write((String)s);
                        ++consMappings;
                    }
                }
                outMappingsBuffer.close();
            }
            SplitMixed.out(outInfoBuffer, "considered mappings: " + consMappings);
            int supportedNormalDeletions = 0;
            int concLeft = 0;
            Collections.sort(components);
            int i7 = 0;
            for (Component comp : components) {
                Vector<Cluster> maxClusters1;
                Vector<Mapping> maxMappings;
                SplitMixed.out(outInfoBuffer, ">>> component " + ++i7 + "/" + components.size());
                if (comp.cluster.isBiChr) {
                    if (comp.concordants == null) {
                        comp.concordants = new Vector();
                    } else {
                        concordantsTotal.addAll(comp.concordants);
                    }
                }
                Vector<Mapping> conflictingSupNormalBlock = new Vector<Mapping>();
                Vector<Mapping> maxExplainBlock = new Vector<Mapping>();
                Vector<Mapping> maxNormBlock = new Vector<Mapping>();
                supportedNormalDeletions = SplitMixed.supportNormalDeletions(minLenMix, maxLenMix, comp, conflictingSupNormalBlockTotal, conflictingSupNormalBlock, maxExplainBlock, supNewNormalBlock, supportedNormalDeletions, outInfoBuffer);
                Cluster cRef = comp.cluster.clone();
                if (!Cluster.refine(cRef, maxExplainBlock, minLenMix, maxLenMix)) {
                    SplitMixed.out(outInfoBuffer, "ERROR: comp.cluster: " + comp.cluster.toString());
                    for (Mapping m : maxExplainBlock) {
                        SplitMixed.out(outInfoBuffer, "m: " + m.toString());
                    }
                    System.exit(1);
                }
                if (!cRef.isBiChr) {
                    if (!comp.noConfNormalBlock.isEmpty() || !comp.confBlockNormal.isEmpty()) {
                        maxMappings = new Vector<Mapping>();
                        Vector<Cluster> currClusters = new Vector<Cluster>();
                        currClusters.add(cRef);
                        maxClusters1 = new Vector();
                        maxClusters1.add(cRef);
                        Vector<Cluster> maxClusters2 = new Vector<Cluster>();
                        SplitMixed.out(outInfoBuffer, "; " + (comp.noConfNormalBlock.size() + comp.confBlockNormal.size()) + " mappings to split.");
                        Long time = System.currentTimeMillis();
                        SplitMixed.findMax2Chromosomes(time, cRef, comp.noConfNormalBlock.size() + comp.confBlockNormal.size(), (Vector)comp.noConfNormalBlock.clone(), (Vector)comp.confBlockNormal.clone(), new Vector<Mapping>(), currClusters, new Vector<Cluster>(), maxMappings, maxClusters1, maxClusters2, minLenMix, maxLenMix);
                        maxClusters1.remove(cRef);
                        newClusters.addAll(maxClusters1);
                        newClusters.addAll(maxClusters2);
                        maxExplainBlock.addAll(maxMappings);
                        explainedRemaining += maxMappings.size();
                        cRef.refineByOuterClusters(maxClusters1);
                        if (!maxClusters1.isEmpty() || !maxExplainBlock.isEmpty()) {
                            SplitMixed.output(outClustersBuffer, outClustersMappingsBuffer, comp.cluster, "NORMAL\t" + (unichrom[comp.cluster.id] ? "het" : "hom"), genesFile, dupsFile, varsFile);
                            SplitMixed.output(outClustersBuffer, outClustersMappingsBuffer, cRef, "REFINED\t---", genesFile, dupsFile, varsFile);
                        }
                        for (Cluster c : maxClusters1) {
                            c.id = ++l;
                            SplitMixed.output(outClustersBuffer, outClustersMappingsBuffer, c, "SOMATIC\t---", genesFile, dupsFile, varsFile);
                        }
                        for (Cluster c : maxClusters2) {
                            c.id = ++l;
                            SplitMixed.output(outClustersBuffer, outClustersMappingsBuffer, c, "SOMATIC\t---", genesFile, dupsFile, varsFile);
                        }
                    } else if (!maxExplainBlock.isEmpty()) {
                        SplitMixed.output(outClustersBuffer, outClustersMappingsBuffer, comp.cluster, "NORMAL\t" + (unichrom[comp.cluster.id] ? "het" : "hom"), genesFile, dupsFile, varsFile);
                        SplitMixed.output(outClustersBuffer, outClustersMappingsBuffer, cRef, "REFINED\t---", genesFile, dupsFile, varsFile);
                    }
                } else if (!(comp.noConfNormalBlock.isEmpty() && comp.confBlockNormal.isEmpty() && comp.concordants.isEmpty())) {
                    maxMappings = new Vector();
                    Vector<Cluster> currClusters1 = new Vector<Cluster>();
                    maxClusters1 = new Vector<Cluster>();
                    currClusters1.add(cRef);
                    maxClusters1.add(cRef);
                    Vector<Cluster> currClusters2 = new Vector<Cluster>();
                    Vector<Cluster> maxClusters2 = new Vector<Cluster>();
                    currClusters2.add(cRef);
                    maxClusters2.add(cRef);
                    Vector<Mapping> maxConcordants = new Vector<Mapping>();
                    SplitMixed.out(outInfoBuffer, "; " + (comp.noConfNormalBlock.size() + comp.concordants.size()) + " mappings to split. ");
                    Long time = System.currentTimeMillis();
                    SplitMixed.findMax2Chromosomes(time, cRef, comp.noConfNormalBlock.size() + comp.concordants.size(), (Vector)comp.noConfNormalBlock.clone(), new Vector<Mapping>(), (Vector)comp.concordants.clone(), new Vector<Mapping>(), currClusters1, currClusters2, new Vector<Mapping>(), maxMappings, maxClusters1, maxClusters2, maxConcordants, minLenMix, maxLenMix);
                    maxClusters1.remove(0);
                    maxClusters2.remove(0);
                    newClusters.addAll(maxClusters1);
                    newClusters.addAll(maxClusters2);
                    Vector<Cluster> temp = new Vector<Cluster>();
                    temp.add(cRef);
                    cRef.refineByOuterMappings(maxConcordants);
                    cRef.refineByOuterClusters(maxClusters1);
                    cRef.refineByOuterClusters(maxClusters2);
                    if (!(maxClusters1.isEmpty() && maxClusters2.isEmpty() && maxConcordants.isEmpty() && maxNormBlock.isEmpty())) {
                        SplitMixed.output(outClustersBuffer, outClustersMappingsBuffer, comp.cluster, "NORMAL\thom", genesFile, dupsFile, varsFile);
                        SplitMixed.output(outClustersBuffer, outClustersMappingsBuffer, cRef, "REFINED\t---", genesFile, dupsFile, varsFile);
                    }
                    for (Cluster c : maxClusters1) {
                        c.id = ++l;
                        SplitMixed.output(outClustersBuffer, outClustersMappingsBuffer, c, "SOMATIC\t---", genesFile, dupsFile, varsFile);
                    }
                    for (Cluster c : maxClusters2) {
                        c.id = ++l;
                        SplitMixed.output(outClustersBuffer, outClustersMappingsBuffer, c, "SOMATIC\t---", genesFile, dupsFile, varsFile);
                    }
                    concNewNormal += maxConcordants.size();
                    concLeft += comp.concordants.size() - maxConcordants.size();
                    maxNormBlock.addAll(maxMappings);
                    explainedRemaining += maxMappings.size();
                } else if (!maxNormBlock.isEmpty()) {
                    SplitMixed.output(outClustersBuffer, outClustersMappingsBuffer, comp.cluster, "NORMAL\thom", genesFile, dupsFile, varsFile);
                    SplitMixed.output(outClustersBuffer, outClustersMappingsBuffer, cRef, "REFINED\t---", genesFile, dupsFile, varsFile);
                }
                maxExplainBlockTotal.addAll(maxExplainBlock);
            }
            int m = 0;
            for (Cluster c : newClusters) {
                m += c.mappings.size();
            }
            SplitMixed.out(outInfoBuffer, ">>> supported normal deletions clusters: " + supportedNormalDeletions);
            SplitMixed.out(outInfoBuffer, ">>> somatic clusters: " + newClusters.size());
            SplitMixed.out(outInfoBuffer, ">>> number of mappings contained in these clusters: " + m);
            SplitMixed.out(outInfoBuffer, ">>> discarded deletion mappings: " + (supNormalTotal.size() + confBlockNormalTotal.size() + noConfNormalBlockTotal.size() - (explainedRemaining + supNewNormalBlock.size() - concNewNormal)));
            SplitMixed.out(outInfoBuffer, ">>> explained deletion mappings: " + (explainedRemaining + supNewNormalBlock.size() - concNewNormal));
            SplitMixed.out(outInfoBuffer, ">>> discarded concordant mappings: " + concLeft);
            SplitMixed.out(outInfoBuffer, ">>> explained concordant mappings: " + concNewNormal);
            SplitMixed.out(outInfoBuffer, "@3\t" + supportedNormalDeletions + "\t" + newClusters.size() + "\t" + m + "\t" + (supNormalTotal.size() + confBlockNormalTotal.size() + noConfNormalBlockTotal.size() - (explainedRemaining + supNewNormalBlock.size() - concNewNormal)) + "\t" + (explainedRemaining + supNewNormalBlock.size() - concNewNormal) + "\t" + concLeft + "\t" + concNewNormal);
            if (outClustersBuffer != null) {
                outClustersBuffer.close();
            }
            if (outClustersMappingsBuffer != null) {
                outClustersMappingsBuffer.close();
            }
            if (outInfoBuffer != null) {
                outInfoBuffer.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static int supportNormalDeletions(int minLenMix, int maxLenMix, Component comp, Vector<Mapping> conflictingSupNormalBlockTotal, Vector<Mapping> conflictingSupNormalBlock, Vector<Mapping> maxExplainBlock, Vector<Mapping> supNewNormalBlock, int supportedNormalDeletions, BufferedWriter outInfoBuffer) {
        if (!comp.supNormal.isEmpty()) {
            ++supportedNormalDeletions;
            HashMap<String, Integer> ci = new HashMap<String, Integer>();
            Vector<Mappings> conflSubs = new Vector<Mappings>();
            SplitMixed.countCi(comp.supNormal, comp.cluster, minLenMix, maxLenMix, ci, conflSubs, -1, "sb?");
            for (Mapping m : comp.supNormal) {
                if (ci.containsKey(m.id)) {
                    conflictingSupNormalBlock.add(m);
                    conflictingSupNormalBlockTotal.add(m);
                    continue;
                }
                maxExplainBlock.add(m);
                supNewNormalBlock.add(m);
            }
            Vector<Object> maxSet = new Vector();
            int maxSize = 0;
            int maxQual = 0;
            Long time = System.currentTimeMillis();
            long max = (long)Math.pow(2.0, conflictingSupNormalBlock.size()) - 1L;
            Vector<Long> list = new Vector<Long>();
            Long i = new Long(1L);
            while (i <= max) {
                list.add(i);
                i = i + 1L;
            }
            Collections.shuffle(list);
            for (Long subset : list) {
                Long currTime;
                if (Long.bitCount(subset) < maxSize) continue;
                Vector<Mapping> ms = SplitMixed.getSubset(conflictingSupNormalBlock, subset);
                Cluster c2 = comp.cluster.clone();
                if (!Cluster.refine(c2, ms, minLenMix, maxLenMix)) continue;
                int qual = 0;
                for (Mapping m : ms) {
                    qual = (int)((double)qual + m.quality);
                }
                if (ms.size() > maxSize) {
                    maxSet = ms;
                    maxQual = qual;
                    maxSize = ms.size();
                    if (maxSize == conflictingSupNormalBlock.size()) break;
                    currTime = System.currentTimeMillis();
                    if (currTime - time <= 600000L) continue;
                    SplitMixed.out(outInfoBuffer, "!!! Support not optimal!");
                    break;
                }
                if (qual <= maxQual) continue;
                maxSet = ms;
                maxQual = qual;
                maxSize = ms.size();
                if (maxSize == conflictingSupNormalBlock.size()) break;
                currTime = System.currentTimeMillis();
                if (currTime - time <= 600000L) continue;
                SplitMixed.out(outInfoBuffer, "!!! Support not optimal!");
                break;
            }
            supNewNormalBlock.addAll(maxSet);
            maxExplainBlock.addAll(maxSet);
            if (conflictingSupNormalBlock.size() > maxSet.size()) {
                Vector<Mapping> newNoConf = new Vector<Mapping>();
                newNoConf.addAll(conflictingSupNormalBlock);
                newNoConf.removeAll(maxSet);
                comp.noConfNormalBlock.addAll(newNoConf);
            }
        }
        return supportedNormalDeletions;
    }

    /*
     * WARNING - void declaration
     */
    private static Vector<Component> composeComponents(int minLenMix, int maxLenMix, Vector<Cluster> normalClusters, Vector<Cluster> consideredClusters, Mappings discordantsMix, Mappings concordantsMix, Vector<Mapping> supNormalTotal, Vector<Mapping> confBlockNormalTotal, Vector<Mapping> noConfNormalBlockTotal, BufferedWriter outInfoBuffer) {
        Vector<Component> toRemove;
        Vector<Cluster> overlappingClusters;
        Vector<Component> components = new Vector<Component>();
        for (Cluster c : consideredClusters) {
            components.add(new Component(c));
        }
        if (concordantsMix != null) {
            for (Mapping m : concordantsMix) {
                overlappingClusters = new Vector<Cluster>();
                for (Cluster c : consideredClusters) {
                    if (!c.isBiChr || (Integer)m.fst - m.readLen >= c.trapezoid.r && (Integer)m.fst >= c.trapezoid.rr || c.trapezoid.l >= (Integer)m.snd + m.readLen && c.trapezoid.ll >= (Integer)m.snd) continue;
                    overlappingClusters.add(c);
                }
                if (!overlappingClusters.isEmpty()) {
                    for (Cluster c : normalClusters) {
                        if ((Integer)m.fst - m.readLen >= c.trapezoid.r && (Integer)m.fst >= c.trapezoid.rr || c.trapezoid.l >= (Integer)m.snd + m.readLen && c.trapezoid.ll >= (Integer)m.snd || overlappingClusters.contains(c)) continue;
                        overlappingClusters.add(c);
                    }
                }
                if (overlappingClusters.isEmpty()) continue;
                if (overlappingClusters.size() > 1) {
                    toRemove = new Vector();
                    for (Component component : components) {
                        if (!overlappingClusters.contains(component.cluster)) continue;
                        toRemove.add(component);
                        for (Mapping mapping : component.supNormal) {
                            supNormalTotal.remove(mapping);
                        }
                        for (Mapping mapping : component.confBlockNormal) {
                            confBlockNormalTotal.remove(mapping);
                        }
                        for (Mapping mapping : component.noConfNormalBlock) {
                            noConfNormalBlockTotal.remove(mapping);
                        }
                    }
                    components.removeAll(toRemove);
                    continue;
                }
                Component comp = null;
                for (Component component : components) {
                    if (!overlappingClusters.contains(component.cluster)) continue;
                    comp = component;
                    break;
                }
                if (comp == null) continue;
                if (comp.concordants == null) {
                    comp.concordants = new Vector();
                }
                comp.concordants.add(m);
            }
        }
        for (Mapping m : discordantsMix) {
            void var15_32;
            overlappingClusters = new Vector();
            for (Cluster c : consideredClusters) {
                if ((Integer)m.fst - m.readLen >= c.trapezoid.r && (Integer)m.fst >= c.trapezoid.rr || c.trapezoid.l >= (Integer)m.snd + m.readLen && c.trapezoid.ll >= (Integer)m.snd) continue;
                overlappingClusters.add(c);
            }
            if (!overlappingClusters.isEmpty()) {
                for (Cluster c : normalClusters) {
                    if ((Integer)m.fst - m.readLen >= c.trapezoid.r && (Integer)m.fst >= c.trapezoid.rr || c.trapezoid.l >= (Integer)m.snd + m.readLen && c.trapezoid.ll >= (Integer)m.snd || overlappingClusters.contains(c)) continue;
                    overlappingClusters.add(c);
                }
            }
            if (overlappingClusters.isEmpty()) continue;
            if (overlappingClusters.size() > 1) {
                toRemove = new Vector();
                for (Component component : components) {
                    if (!overlappingClusters.contains(component.cluster)) continue;
                    toRemove.add(component);
                    for (Mapping mapping : component.supNormal) {
                        supNormalTotal.remove(mapping);
                    }
                    for (Mapping mapping : component.confBlockNormal) {
                        confBlockNormalTotal.remove(mapping);
                    }
                    for (Mapping mapping : component.noConfNormalBlock) {
                        noConfNormalBlockTotal.remove(mapping);
                    }
                }
                components.removeAll(toRemove);
                continue;
            }
            Cluster cluster = (Cluster)overlappingClusters.firstElement();
            Object var15_30 = null;
            for (Component comp2 : components) {
                if (!overlappingClusters.contains(comp2.cluster)) continue;
                Component component = comp2;
                break;
            }
            if (var15_32 == null) continue;
            char ch = SplitMixed.checkCompatibility(m, cluster, minLenMix, maxLenMix);
            switch (ch) {
                case 'n': {
                    var15_32.supNormal.add(m);
                    supNormalTotal.add(m);
                    break;
                }
                case 'b': {
                    var15_32.confBlockNormal.add(m);
                    confBlockNormalTotal.add(m);
                    break;
                }
                case 's': {
                    var15_32.confBlockNormal.add(m);
                    confBlockNormalTotal.add(m);
                    break;
                }
                default: {
                    var15_32.noConfNormalBlock.add(m);
                    noConfNormalBlockTotal.add(m);
                }
            }
        }
        boolean again = false;
        while (again) {
            for (Mapping m : discordantsMix) {
                again = false;
                toRemove = new Vector<Component>();
                block24: for (Component component : components) {
                    Vector<Mapping> vector = component.getAllMappings();
                    if (vector.contains(m)) continue;
                    for (Mapping m2 : vector) {
                        if ((Integer)m.snd + m.readLen <= (Integer)m2.fst && (Integer)m.snd <= (Integer)m2.fst - m2.readLen || (Integer)m.fst >= (Integer)m2.snd + m2.readLen && (Integer)m.fst - m.readLen >= (Integer)m2.snd) continue;
                        component.noConfNormalBlock.add(m);
                        noConfNormalBlockTotal.add(m);
                        again = true;
                        for (Cluster c : normalClusters) {
                            if ((Integer)m.fst - m.readLen >= c.trapezoid.r && (Integer)m.fst >= c.trapezoid.rr || c.trapezoid.l >= (Integer)m.snd + m.readLen && c.trapezoid.ll >= (Integer)m.snd) continue;
                            toRemove.add(component);
                            for (Mapping mapping : component.supNormal) {
                                supNormalTotal.remove(mapping);
                            }
                            for (Mapping mapping : component.confBlockNormal) {
                                confBlockNormalTotal.remove(mapping);
                            }
                            for (Mapping mapping : component.noConfNormalBlock) {
                                noConfNormalBlockTotal.remove(mapping);
                            }
                            continue block24;
                        }
                        continue block24;
                    }
                }
                components.removeAll(toRemove);
            }
        }
        SplitMixed.out(outInfoBuffer, ">>> " + consideredClusters.size() + " unichromosomal non-overlapping clusters, " + components.size() + " proper components");
        return components;
    }

    public static void out(BufferedWriter b, String s) {
        if (b == null) {
            System.out.println("null: " + s);
        } else {
            try {
                System.out.println(s);
                b.write(String.valueOf(s) + "\n");
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    public static void output(BufferedWriter b, BufferedWriter bDetail, Cluster c, String prefix, String genesFile, String dupsFile, String varsFile) {
        if (b != null) {
            double min = 2.147483647E9;
            double sum = 0.0;
            for (Mapping m : c.mappings) {
                min = Math.min(min, m.quality);
                sum += m.quality.doubleValue();
            }
            sum /= (double)c.mappings.size();
            String geneL = "-";
            int distL = Integer.MAX_VALUE;
            String geneR = "-";
            int distR = Integer.MAX_VALUE;
            if (genesFile != null) {
                try {
                    String line = null;
                    File file = new File(genesFile);
                    BufferedReader br = new BufferedReader(new FileReader(file));
                    while ((line = br.readLine()) != null) {
                        if (line.charAt(0) == '#') continue;
                        String[] cols = line.split("\t");
                        Integer l = Integer.parseInt(cols[0]);
                        Integer r = Integer.parseInt(cols[1]);
                        if (l > c.trapezoid.l && l - c.trapezoid.r + 1 < distR) {
                            distR = l - c.trapezoid.r + 1;
                            geneR = String.valueOf(cols[3]) + "(" + cols[4] + ")";
                        }
                        if (r >= c.trapezoid.r || c.trapezoid.l - r + 1 >= distL) continue;
                        distL = c.trapezoid.l - r + 1;
                        geneL = String.valueOf(cols[3]) + "(" + cols[4] + ")";
                    }
                    br.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            String dups = "";
            if (dupsFile != null) {
                try {
                    String line = null;
                    File file = new File(dupsFile);
                    BufferedReader br = new BufferedReader(new FileReader(file));
                    while ((line = br.readLine()) != null) {
                        if (line.charAt(0) == '#') continue;
                        String[] cols = line.split("\t");
                        Integer l = Integer.parseInt(cols[1]);
                        Integer r = Integer.parseInt(cols[2]);
                        if (r <= c.trapezoid.l || l >= c.trapezoid.r) continue;
                        dups = String.valueOf(dups) + cols[cols.length - 1] + ",";
                    }
                    br.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            dups = dups.length() > 0 ? dups.substring(0, dups.length() - 1) : "-";
            String vars = "";
            if (varsFile != null) {
                try {
                    String line = null;
                    File file = new File(varsFile);
                    BufferedReader br = new BufferedReader(new FileReader(file));
                    while ((line = br.readLine()) != null) {
                        if (line.charAt(0) == '#') continue;
                        String[] cols = line.split(",");
                        Integer l = Integer.parseInt(cols[13]);
                        Integer r = Integer.parseInt(cols[14]);
                        if (r <= c.trapezoid.l || l >= c.trapezoid.r) continue;
                        double cSize = c.trapezoid.r - c.trapezoid.l;
                        if (!((double)(Math.min(r, c.trapezoid.r) - Math.max(l, c.trapezoid.l)) >= 0.9 * cSize)) continue;
                        vars = String.valueOf(vars) + cols[1] + ",";
                    }
                    br.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            vars = vars.length() > 0 ? vars.substring(0, vars.length() - 1) : "-";
            try {
                b.write(String.valueOf(c.id) + "\t" + prefix + "\t" + c.trapezoid.ll + "\t" + c.trapezoid.l + "\t" + c.trapezoid.r + "\t" + c.trapezoid.rr + "\t" + c.trapezoid.ranMin + "\t" + c.trapezoid.ranMax + "\t" + c.mappings.size() + "\t" + min + "\t" + sum + "\t" + geneL + "\t" + (distL == Integer.MAX_VALUE ? "-" : Integer.valueOf(distL)) + "\t" + geneR + "\t" + (distR == Integer.MAX_VALUE ? "-" : Integer.valueOf(distR)) + "\t" + dups + "\t" + vars + "\n");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            SplitMixed.outputDetails(bDetail, c);
        }
    }

    public static void outputDetails(BufferedWriter b, Cluster c) {
        if (b != null) {
            try {
                b.write(String.valueOf(c.id) + "\t");
                for (Mapping m : c.mappings) {
                    b.write(String.valueOf(m.toString()) + "\t");
                }
                b.write("\n");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    public static Vector<Mapping> getSubset(Vector<Mapping> v, long index) {
        Vector<Mapping> subset = new Vector<Mapping>();
        String indexset = Long.toBinaryString(index);
        int i = 0;
        while (i < indexset.length()) {
            if (indexset.charAt(i) == '1') {
                subset.add(v.get(v.size() - i - 1));
            }
            ++i;
        }
        return subset;
    }

    public static char checkCompatibility(Vector<Mapping> ms, int minLenMix, int maxLenMix) {
        int ll = Integer.MAX_VALUE;
        int rr = 0;
        for (Mapping m : ms) {
            ll = Math.min(ll, (Integer)m.fst - m.readLen);
            rr = Math.max(rr, (Integer)m.snd + m.readLen);
        }
        int result = 63;
        boolean[] cov = new boolean[rr - ll];
        Arrays.fill(cov, false);
        for (Mapping mms : ms) {
            int i = 0;
            while (i < mms.readLen) {
                int p = (Integer)mms.fst - i - ll;
                if (p >= 0 && p < cov.length) {
                    cov[p] = true;
                }
                if ((p = (Integer)mms.snd + i - ll) >= 0 && p < cov.length) {
                    cov[p] = true;
                }
                ++i;
            }
        }
        for (Mapping m : ms) {
            int mLeft = 0;
            int mMaxRun = 0;
            int currRun = 0;
            int i = (Integer)m.fst - ll;
            while (i < (Integer)m.snd - ll) {
                if (cov[i]) {
                    mMaxRun = Math.max(currRun, mMaxRun);
                    currRun = 0;
                } else {
                    ++mLeft;
                    ++currRun;
                }
                ++i;
            }
            mMaxRun = Math.max(currRun, mMaxRun);
            int mRanMin = m.getLength() - maxLenMix + 1;
            if (mLeft < mRanMin) {
                return 's';
            }
            if (mMaxRun >= mRanMin) continue;
            result = 98;
        }
        return (char)result;
    }

    public static char checkCompatibility(Vector<Mapping> ms, Cluster c, int minLenMix, int maxLenMix) {
        int p;
        int i;
        if (c == null) {
            return SplitMixed.checkCompatibility(ms, minLenMix, maxLenMix);
        }
        int mRanMin = 0;
        int mRanMax = Integer.MAX_VALUE;
        int l = c.trapezoid.l;
        int r = c.trapezoid.r;
        int ll = c.trapezoid.ll;
        int rr = c.trapezoid.rr;
        for (Mapping m : ms) {
            mRanMin = Math.max(mRanMin, m.getLength() - maxLenMix);
            mRanMax = Math.min(mRanMax, m.getLength() - minLenMix);
            l = Math.max(l, (Integer)m.fst);
            r = Math.min(r, (Integer)m.snd);
            ll = Math.min(ll, (Integer)m.fst - m.readLen + 1);
            rr = Math.max(rr, (Integer)m.snd + m.readLen - 1);
        }
        if (maxLenMix >= 0 && mRanMin <= c.trapezoid.ranMax && mRanMax >= c.trapezoid.ranMin && r - l > mRanMin && r - l > c.trapezoid.ranMin) {
            return 'n';
        }
        int result = 63;
        boolean[] covR = new boolean[rr - ll];
        boolean[] covM = new boolean[rr - ll];
        boolean[] covC = new boolean[rr - ll];
        Arrays.fill(covR, false);
        Arrays.fill(covM, false);
        Arrays.fill(covC, false);
        for (Mapping mc : c.mappings) {
            i = 0;
            while (i < mc.readLen) {
                p = (Integer)mc.fst - i - ll;
                if (p >= 0 && p < covR.length) {
                    covR[p] = true;
                }
                if ((p = (Integer)mc.snd + i - ll) >= 0 && p < covR.length) {
                    covR[p] = true;
                }
                ++i;
            }
        }
        for (Mapping mms : ms) {
            i = 0;
            while (i < mms.readLen) {
                p = (Integer)mms.fst - i - ll;
                if (p >= 0 && p < covR.length) {
                    covR[p] = true;
                }
                if ((p = (Integer)mms.snd + i - ll) >= 0 && p < covR.length) {
                    covR[p] = true;
                }
                ++i;
            }
            i = (Integer)mms.fst - mms.readLen + 1;
            while (i < (Integer)mms.snd + mms.readLen) {
                p = i - ll;
                if (p >= 0 && p < covR.length) {
                    covM[p] = true;
                }
                ++i;
            }
        }
        int i2 = c.trapezoid.ll;
        while (i2 <= c.trapezoid.rr) {
            int p2 = i2 - ll;
            if (p2 >= 0 && p2 < covR.length) {
                covC[p2] = true;
            }
            ++i2;
        }
        int cLeft = 0;
        int cMaxRun = 0;
        int currRun = 0;
        int i3 = c.trapezoid.l - ll + 1;
        while (i3 < c.trapezoid.r - ll) {
            if (covM[i3]) {
                cMaxRun = Math.max(cMaxRun, currRun);
                currRun = 0;
            } else {
                ++currRun;
            }
            if (!covR[i3]) {
                ++cLeft;
            }
            ++i3;
        }
        cMaxRun = Math.max(cMaxRun, currRun);
        if (cLeft < c.trapezoid.ranMin) {
            return 's';
        }
        if (cMaxRun < c.trapezoid.ranMin) {
            result = 98;
        }
        if (maxLenMix >= 0) {
            for (Mapping m : ms) {
                int mLeft = 0;
                int mMaxRun = 0;
                currRun = 0;
                int i4 = (Integer)m.fst - ll + 1;
                while (i4 < (Integer)m.snd - ll) {
                    if (covC[i4]) {
                        mMaxRun = Math.max(mMaxRun, currRun);
                        currRun = 0;
                    } else {
                        ++currRun;
                    }
                    if (!covR[i4]) {
                        ++mLeft;
                    }
                    ++i4;
                }
                mMaxRun = Math.max(currRun, mMaxRun);
                mRanMin = m.getLength() - maxLenMix;
                if (mLeft < mRanMin) {
                    return 's';
                }
                if (mMaxRun >= mRanMin) continue;
                result = 98;
            }
        }
        return (char)result;
    }

    public static char checkCompatibility(Mapping m, Cluster c, int minLenMix, int maxLenMix) {
        Vector<Mapping> ms = new Vector<Mapping>();
        ms.add(m);
        return SplitMixed.checkCompatibility(ms, c, minLenMix, maxLenMix);
    }

    public static boolean checkCompatibility(Cluster c, Vector<Cluster> cs, Vector<Mapping> concordants, Vector<Cluster> clusters) {
        for (Cluster c1 : cs) {
            int i;
            int p;
            int l = c1.trapezoid.l;
            int r = c1.trapezoid.r;
            for (Cluster c2 : cs) {
                if (c2 == c1 || c2 == c) continue;
                if (c2.trapezoid.ll <= l && c2.trapezoid.rr >= r) {
                    return false;
                }
                if (c2.trapezoid.ll <= l && c2.trapezoid.rr > l) {
                    l = c2.trapezoid.rr;
                    continue;
                }
                if (c2.trapezoid.ll > r || c2.trapezoid.rr <= r) continue;
                r = c2.trapezoid.ll;
            }
            if (r - l - 1 < c1.trapezoid.ranMin) {
                return false;
            }
            if (concordants == null || c1 != c || concordants.isEmpty()) continue;
            int length = r - l - 1;
            boolean[] a = new boolean[length];
            Arrays.fill(a, false);
            for (Mapping m : concordants) {
                p = (Integer)m.fst - m.readLen + 1;
                while (p <= (Integer)m.snd + m.readLen - 1) {
                    i = p - l - 1;
                    if (i >= 0 && i < length) {
                        a[i] = true;
                    }
                    ++p;
                }
            }
            if (clusters != null) {
                for (Cluster cl : clusters) {
                    if (cl == c) continue;
                    p = cl.trapezoid.ll;
                    while (p <= cl.trapezoid.rr) {
                        i = p - l - 1;
                        if (i >= 0 && i < length) {
                            a[i] = true;
                        }
                        ++p;
                    }
                }
            }
            int maxRun = 0;
            int currRun = 0;
            p = l + 1;
            while (p < r) {
                i = p - l - 1;
                if (a[i]) {
                    maxRun = Math.max(maxRun, currRun);
                    currRun = 0;
                } else {
                    ++currRun;
                }
                ++p;
            }
            if ((maxRun = Math.max(maxRun, currRun)) >= c1.trapezoid.ranMin) continue;
            return false;
        }
        return true;
    }

    public static int readMappings(String filename, int minLen, int maxLen, Mappings concordants, Mappings discordants, BufferedWriter outInfoBuffer) {
        return SplitMixed.readMappings(filename, minLen, maxLen, concordants, discordants, null, outInfoBuffer);
    }

    public static int readMappings(String filename, int minLen, int maxLen, Mappings concordants, Mappings discordants, Vector<Cluster> clusters, BufferedWriter outInfoBuffer) {
        HashMap<String, Integer> reads = new HashMap<String, Integer>();
        int genomeLength = 0;
        int ins = 0;
        int conc = 0;
        try {
            String line1;
            File file = new File(filename);
            BufferedReader br1 = new BufferedReader(new FileReader(file));
            while ((line1 = br1.readLine()) != null) {
                Mapping mapping = null;
                String[] cols = line1.split("\t");
                Integer pos = Integer.parseInt(cols[2]);
                String id = cols[0].substring(0, cols[0].indexOf(47));
                if (reads.containsKey(id)) {
                    Double q = Double.parseDouble(cols[8]);
                    int p1 = (Integer)reads.get(id);
                    int p2 = Integer.parseInt(cols[2]);
                    int readlen = Integer.parseInt(cols[13]);
                    if (q > 0.0) {
                        mapping = p1 < p2 ? new Mapping(p1 + readlen - 1, p2, id, q, readlen) : new Mapping(p2 + readlen - 1, p1, id, q, readlen);
                        if (mapping.getLength() >= minLen && mapping.getLength() <= maxLen) {
                            if (concordants != null) {
                                if (clusters != null) {
                                    for (Cluster c : clusters) {
                                        if (!c.isBiChr || (Integer)mapping.fst - mapping.readLen >= c.trapezoid.r && (Integer)mapping.fst >= c.trapezoid.rr || c.trapezoid.l >= (Integer)mapping.snd + mapping.readLen && c.trapezoid.ll >= (Integer)mapping.snd) continue;
                                        if (mapping.quality >= 20.0) {
                                            concordants.add(mapping);
                                        }
                                        break;
                                    }
                                } else if (mapping.quality >= 20.0) {
                                    concordants.add(mapping);
                                }
                            }
                            ++conc;
                        } else if (mapping.getLength() > maxLen) {
                            discordants.add(mapping);
                        } else {
                            ++ins;
                        }
                        if ((Integer)mapping.snd > genomeLength) {
                            genomeLength = (Integer)mapping.snd;
                        }
                    }
                    reads.remove(id);
                    continue;
                }
                reads.put(id, pos);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        SplitMixed.out(outInfoBuffer, ">>> mappings read: " + conc + " concordant, " + discordants.size() + " deletions, " + ins + " insertions (discarded); " + reads.size() + " unpaired reads");
        SplitMixed.out(outInfoBuffer, "@2\t" + conc + "\t" + discordants.size() + "\t" + ins + "\t" + reads.size() + "\t");
        return genomeLength;
    }

    public static void countCi(Vector<Mapping> ms, Cluster c, int minLenMix, int maxLenMix, Map<String, Integer> ci, Vector<Mappings> conflSubs, int maxDepth, String s) {
        Vector<Mapping> ms2 = new Vector<Mapping>();
        boolean conf = false;
        for (Mapping m : ms) {
            ms2.add(m);
            boolean bl = conf = s.indexOf(SplitMixed.checkCompatibility(ms2, c, minLenMix, maxLenMix)) >= 0;
            if (conf) break;
        }
        if (!conf) {
            return;
        }
        Mappings ms3 = new Mappings();
        ms3.addAll(ms2);
        for (Mapping m_skip : ms2) {
            int pos = ms3.indexOf(m_skip);
            ms3.remove(m_skip);
            if (s.indexOf(SplitMixed.checkCompatibility(ms3, c, minLenMix, maxLenMix)) >= 0) continue;
            ms3.add(pos, m_skip);
        }
        Collections.sort(ms3);
        if (!conflSubs.contains(ms3)) {
            conflSubs.add(ms3);
            for (Mapping m : ms3) {
                Integer oldCi = ci.remove(m.id);
                if (oldCi == null) {
                    oldCi = 0;
                }
                ci.put(m.id, oldCi + 1);
            }
        }
        if (maxDepth > 0 || maxDepth < 0) {
            for (Mapping m_skip : ms3) {
                Mappings ms4 = new Mappings();
                for (Mapping m : ms) {
                    if (m == m_skip) continue;
                    ms4.add(m);
                }
                SplitMixed.countCi(ms4, c, minLenMix, maxLenMix, ci, conflSubs, --maxDepth, s);
            }
        }
    }

    public static boolean findMax2Chromosomes(Long time, Cluster c, int msOrigSize, Vector<Mapping> ms12, Vector<Mapping> ms2, Vector<Mapping> currMappings, Vector<Cluster> currClusters1, Vector<Cluster> currClusters2, Vector<Mapping> maxMappings, Vector<Cluster> maxClusters1, Vector<Cluster> maxClusters2, int minLen, int maxLen) {
        return SplitMixed.findMax2Chromosomes(time, c, msOrigSize, ms12, ms2, null, currMappings, currClusters1, currClusters2, null, maxMappings, maxClusters1, maxClusters2, null, minLen, maxLen);
    }

    public static boolean findMax2Chromosomes(Long time, Cluster c, int msOrigSize, Vector<Mapping> ms12, Vector<Mapping> ms2, Vector<Mapping> concordants, Vector<Mapping> currMappings, Vector<Cluster> currClusters1, Vector<Cluster> currClusters2, Vector<Mapping> currConcordants, Vector<Mapping> maxMappings, Vector<Cluster> maxClusters1, Vector<Cluster> maxClusters2, Vector<Mapping> maxConcordants, int minLen, int maxLen) {
        if (ms2.isEmpty() && ms12.isEmpty() && (concordants == null || concordants.isEmpty()) && currMappings.size() >= maxMappings.size() && (currMappings.size() > maxMappings.size() || concordants != null && currConcordants.size() > maxConcordants.size())) {
            maxMappings.removeAllElements();
            maxMappings.addAll(currMappings);
            maxClusters1.removeAllElements();
            maxClusters1.addAll(currClusters1);
            maxClusters2.removeAllElements();
            maxClusters2.addAll(currClusters2);
            if (concordants != null) {
                maxConcordants.removeAllElements();
                maxConcordants.addAll(currConcordants);
            }
            return msOrigSize == maxMappings.size() && (concordants == null || concordants.size() == maxConcordants.size());
        }
        Long currTime = System.currentTimeMillis();
        if (currTime - time > 600000L) {
            System.out.println("!!! Assignment not optimal!");
            return true;
        }
        int deleted = msOrigSize - ms12.size() - ms2.size() - (concordants == null ? 0 : concordants.size()) - currMappings.size();
        int maxDel = msOrigSize - maxMappings.size();
        boolean done = false;
        if (concordants != null && !concordants.isEmpty()) {
            Mapping conc = concordants.firstElement();
            Vector concsClone = (Vector)concordants.clone();
            concsClone.remove(0);
            currMappings.add(conc);
            currConcordants.add(conc);
            Vector<Cluster> temp = new Vector<Cluster>();
            temp.add(c);
            if (SplitMixed.checkCompatibility(c, temp, currConcordants, null)) {
                done |= SplitMixed.findMax2Chromosomes(time, c, msOrigSize, ms12, ms2, concsClone, currMappings, currClusters1, currClusters2, currConcordants, maxMappings, maxClusters1, maxClusters2, maxConcordants, minLen, maxLen);
            }
            currConcordants.remove(conc);
            currMappings.remove(conc);
            if (deleted < maxDel) {
                done |= SplitMixed.findMax2Chromosomes(time, c, msOrigSize, ms12, ms2, concsClone, currMappings, currClusters1, currClusters2, currConcordants, maxMappings, maxClusters1, maxClusters2, maxConcordants, minLen, maxLen);
            }
            return done;
        }
        if (!ms2.isEmpty()) {
            Mapping m = ms2.firstElement();
            Vector ms2Clone = (Vector)ms2.clone();
            ms2Clone.remove(0);
            Cluster cNew = new Cluster();
            cNew.add(m, minLen, maxLen);
            currClusters2.add(cNew);
            currMappings.add(m);
            if (SplitMixed.checkCompatibility(null, currClusters2, null, null)) {
                done |= SplitMixed.findMax2Chromosomes(time, c, msOrigSize, ms12, ms2Clone, concordants, currMappings, currClusters1, currClusters2, currConcordants, maxMappings, maxClusters1, maxClusters2, maxConcordants, minLen, maxLen);
            }
            currClusters2.remove(cNew);
            currMappings.remove(m);
            if (done) {
                return true;
            }
            for (Cluster c2 : currClusters2) {
                int newL;
                int newR;
                if (c2 == c || (newR = Math.min((Integer)m.snd, c2.trapezoid.r)) <= (newL = Math.max((Integer)m.fst, c2.trapezoid.l))) continue;
                int newRanMin = Math.max(m.getLength() - maxLen, c2.trapezoid.ranMin);
                int newRanMax = Math.min(m.getLength() - minLen, c2.trapezoid.ranMax);
                if (newRanMax < newRanMin || newR - newL + 1 < newRanMin) continue;
                Cluster cCopy = c2.clone();
                cCopy.add(m, minLen, maxLen);
                Vector currClustersCopy = (Vector)currClusters2.clone();
                currClustersCopy.remove(c2);
                currClustersCopy.add(cCopy);
                currMappings.add(m);
                if (SplitMixed.checkCompatibility(null, currClustersCopy, null, null)) {
                    done |= SplitMixed.findMax2Chromosomes(time, c, msOrigSize, ms12, ms2Clone, concordants, currMappings, currClusters1, currClustersCopy, currConcordants, maxMappings, maxClusters1, maxClusters2, maxConcordants, minLen, maxLen);
                }
                currMappings.remove(m);
                if (!done) continue;
                return true;
            }
            if (deleted < maxDel) {
                SplitMixed.findMax2Chromosomes(time, c, msOrigSize, ms12, ms2Clone, concordants, currMappings, currClusters1, currClusters2, currConcordants, maxMappings, maxClusters1, maxClusters2, maxConcordants, minLen, maxLen);
            }
            return done;
        }
        if (!ms12.isEmpty()) {
            Vector currClustersCopy;
            Cluster cCopy;
            int newRanMax;
            int newRanMin;
            int newL;
            int newR;
            Mapping m = ms12.firstElement();
            Vector ms12Clone = (Vector)ms12.clone();
            ms12Clone.remove(0);
            Cluster cNew = new Cluster();
            cNew.add(m, minLen, maxLen);
            currClusters1.add(cNew);
            currMappings.add(m);
            if (SplitMixed.checkCompatibility(c, currClusters1, currConcordants, currClusters2)) {
                done |= SplitMixed.findMax2Chromosomes(time, c, msOrigSize, ms12Clone, ms2, concordants, currMappings, currClusters1, currClusters2, currConcordants, maxMappings, maxClusters1, maxClusters2, maxConcordants, minLen, maxLen);
            }
            currClusters1.remove(cNew);
            currMappings.remove(m);
            if (done) {
                return true;
            }
            for (Cluster c2 : currClusters1) {
                if (c2 == c || (newR = Math.min((Integer)m.snd, c2.trapezoid.r)) <= (newL = Math.max((Integer)m.fst, c2.trapezoid.l))) continue;
                newRanMin = Math.max(m.getLength() - maxLen, c2.trapezoid.ranMin);
                newRanMax = Math.min(m.getLength() - minLen, c2.trapezoid.ranMax);
                if (newRanMax < newRanMin || newR - newL - 1 < newRanMin) continue;
                cCopy = c2.clone();
                cCopy.add(m, minLen, maxLen);
                currClustersCopy = (Vector)currClusters1.clone();
                currClustersCopy.remove(c2);
                currClustersCopy.add(cCopy);
                currMappings.add(m);
                if (SplitMixed.checkCompatibility(c, currClustersCopy, currConcordants, currClusters2)) {
                    done |= SplitMixed.findMax2Chromosomes(time, c, msOrigSize, ms12Clone, ms2, concordants, currMappings, currClustersCopy, currClusters2, currConcordants, maxMappings, maxClusters1, maxClusters2, maxConcordants, minLen, maxLen);
                }
                currMappings.remove(m);
                if (!done) continue;
                return true;
            }
            cNew = new Cluster();
            cNew.add(m, minLen, maxLen);
            currClusters2.add(cNew);
            currMappings.add(m);
            if (SplitMixed.checkCompatibility(c, currClusters2, currConcordants, currClusters1)) {
                done |= SplitMixed.findMax2Chromosomes(time, c, msOrigSize, ms12Clone, ms2, concordants, currMappings, currClusters1, currClusters2, currConcordants, maxMappings, maxClusters1, maxClusters2, maxConcordants, minLen, maxLen);
            }
            currClusters2.remove(cNew);
            currMappings.remove(m);
            if (done) {
                return true;
            }
            for (Cluster c2 : currClusters2) {
                if (c2 == c || (newR = Math.min((Integer)m.snd, c2.trapezoid.r)) <= (newL = Math.max((Integer)m.fst, c2.trapezoid.l))) continue;
                newRanMin = Math.max(m.getLength() - maxLen, c2.trapezoid.ranMin);
                newRanMax = Math.min(m.getLength() - minLen, c2.trapezoid.ranMax);
                if (newRanMax < newRanMin || newR - newL - 1 < newRanMin) continue;
                cCopy = c2.clone();
                cCopy.add(m, minLen, maxLen);
                currClustersCopy = (Vector)currClusters2.clone();
                if (!currClustersCopy.remove(c2)) {
                    System.out.println("AAARGH!");
                }
                currClustersCopy.add(cCopy);
                currMappings.add(m);
                if (SplitMixed.checkCompatibility(c, currClustersCopy, currConcordants, currClusters1)) {
                    done |= SplitMixed.findMax2Chromosomes(time, c, msOrigSize, ms12Clone, ms2, concordants, currMappings, currClusters1, currClustersCopy, currConcordants, maxMappings, maxClusters1, maxClusters2, maxConcordants, minLen, maxLen);
                }
                if (!currMappings.remove(m)) {
                    System.out.println("AAARGH2!");
                }
                if (!done) continue;
                return true;
            }
            if (deleted < maxDel) {
                SplitMixed.findMax2Chromosomes(time, c, msOrigSize, ms12Clone, ms2, concordants, currMappings, currClusters1, currClusters2, currConcordants, maxMappings, maxClusters1, maxClusters2, maxConcordants, minLen, maxLen);
            }
        }
        return done;
    }
}

