/*
 * Decompiled with CFR 0.152.
 */
package conflicts;

import conflicts.Cluster;
import conflicts.Mapping;
import conflicts.Mappings;
import conflicts.SplitMixed;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Vector;

public class SplitMixedConcordantRegion {
    public static void main(String[] args) {
        String clustersFileNormal = args[0];
        int minLenNormal = Integer.parseInt(args[1]);
        int maxLenNormal = Integer.parseInt(args[2]);
        int minClusterSize = Integer.parseInt(args[3]);
        String mappingsFileNormal = args[4];
        int minLenMix = Integer.parseInt(args[5]);
        int maxLenMix = Integer.parseInt(args[6]);
        String mappingsFileMix = args[7];
        String outfile = args[8];
        int l = 0;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            System.out.println(s);
            ++n2;
        }
        int genomeLength = 0;
        boolean[] unichrom = null;
        boolean[] overlapping = null;
        Vector<Cluster> normalClusters = new Vector<Cluster>();
        try {
            String line1;
            int i;
            Mappings concordantsNormal = new Mappings();
            Mappings discordantsNormal = new Mappings();
            genomeLength = SplitMixed.readMappings(mappingsFileNormal, minLenNormal, maxLenNormal, concordantsNormal, discordantsNormal, null);
            int compressionFactor = 10;
            int arrayLength = genomeLength / compressionFactor + 1;
            int[] concCoverage = new int[arrayLength];
            int[] discCoverage = new int[arrayLength];
            int i2 = 0;
            while (i2 < arrayLength) {
                concCoverage[i2] = 0;
                discCoverage[i2] = 0;
                ++i2;
            }
            for (Mapping mapping : concordantsNormal) {
                i = (Integer)mapping.fst;
                while (i <= (Integer)mapping.snd) {
                    int n3 = i / compressionFactor;
                    concCoverage[n3] = concCoverage[n3] + 1;
                    ++i;
                }
            }
            concordantsNormal.removeAllElements();
            for (Mapping mapping : discordantsNormal) {
                i = (Integer)mapping.fst;
                while (i <= (Integer)mapping.snd) {
                    int n4 = i / compressionFactor;
                    discCoverage[n4] = discCoverage[n4] + 1;
                    ++i;
                }
            }
            double avgCovCon = 0.0;
            i = 1;
            while (i <= genomeLength) {
                avgCovCon += (double)concCoverage[i / compressionFactor];
                ++i;
            }
            System.out.println(">>> average coverage by concordant mappings:\n" + (avgCovCon /= (double)genomeLength));
            File file = new File(clustersFileNormal);
            BufferedReader br1 = new BufferedReader(new FileReader(file));
            int pos1 = 0;
            while ((line1 = br1.readLine()) != null) {
                Cluster cluster1 = new Cluster(line1, l, maxLenNormal, minLenNormal);
                if (cluster1.size() >= minClusterSize) {
                    normalClusters.add(cluster1);
                    ++l;
                }
                ++pos1;
            }
            br1.close();
            System.out.println("normal clusters read: " + normalClusters.size());
            Mappings discordantsMix = new Mappings();
            System.out.println(">>> reading mixed set...");
            genomeLength = Math.max(SplitMixed.readMappings(mappingsFileMix, minLenMix, maxLenMix, null, discordantsMix, null), genomeLength);
            Vector<Mapping> ms = new Vector<Mapping>();
            for (Mapping m : discordantsMix) {
                boolean overlap = false;
                for (Cluster c : normalClusters) {
                    if ((Integer)m.fst - m.readLen >= c.trapezoid.r && (Integer)m.fst >= c.trapezoid.rr || c.trapezoid.l >= (Integer)m.snd + m.readLen && c.trapezoid.ll >= (Integer)m.snd) continue;
                    overlap = true;
                    break;
                }
                if (overlap) continue;
                ms.add(m);
            }
            System.out.println(">>> mappings not overlapping any cluster: " + ms.size());
            File outFile = new File(outfile);
            BufferedWriter outBuffer = new BufferedWriter(new FileWriter(outFile));
            int count = 0;
            for (Mapping m : ms) {
                double avgCovByConc = 0.0;
                int i3 = (Integer)m.fst;
                while (i3 < (Integer)m.snd) {
                    if (i3 / compressionFactor < arrayLength) {
                        avgCovByConc += (double)concCoverage[i3 / compressionFactor];
                    }
                    ++i3;
                }
                if (!((avgCovByConc /= (double)((Integer)m.snd - (Integer)m.fst)) / avgCovCon > 0.1)) continue;
                String s = "";
                s = String.valueOf(s) + m.id + "\t";
                s = String.valueOf(s) + "21\t" + ((Integer)m.fst - m.readLen) + "\t" + m.fst + "\t+\t";
                s = String.valueOf(s) + "21\t" + m.snd + "\t" + ((Integer)m.snd - m.readLen) + "\t-\t\n";
                outBuffer.write(s);
                ++count;
            }
            outBuffer.close();
            System.out.println(">>> mappings with high enough support by concordant mappings in normal set: " + count);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

